// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDownloadsMetrics_h
#define mozilla_GleanDownloadsMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace downloads {
  /**
   * generated from downloads.panel_shown
   * The count of how many times the downloads panel was shown per session. This metric was generated to correspond to the Legacy Telemetry scalar downloads.panel_shown.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> panel_shown(305);

  /**
   * generated from downloads.added_file_extension
   */
  struct AddedFileExtensionExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when downloading a new file. This event was generated to correspond to the Legacy Telemetry event downloads.added#fileExtension.
   */
  constexpr impl::EventMetric<AddedFileExtensionExtra> added_file_extension(306);

  /**
   * generated from downloads.file_opened
   * The count of how many times files were opened from the download panel. This metric was generated to correspond to the Legacy Telemetry scalar downloads.file_opened.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> file_opened(307);

  /**
   * generated from downloads.user_action_on_blocked_download
   * Users action on blocked download, keyed by verdict type (0=Number of blocked downloads, 1=Confirm block, 2=Confirm unblock)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram DOWNLOADS_USER_ACTION_ON_BLOCKED_DOWNLOAD.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> user_action_on_blocked_download(308);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDownloadsMetrics_h
