// -*- mode: C++ -*-

/* This file is auto-generated by run_glean_parser.py.
   It is only for internal use by types in
   toolkit/components/glean/bindings/private */

#include "mozilla/AppShutdown.h"
#include "mozilla/ClearOnShutdown.h"
#include "mozilla/glean/bindings/GleanJSMetricsLookup.h"
#include "mozilla/glean/bindings/jog/JOG.h"
#include "mozilla/Maybe.h"
#include "mozilla/Telemetry.h"
#include "nsIThread.h"
#include "nsThreadUtils.h"

#ifndef mozilla_glean_EventGifftMap_h
#define mozilla_glean_EventGifftMap_h

#define DYNAMIC_METRIC_BIT (26)
#define GLEAN_METRIC_ID(id) ((id) & ((1ULL << 27) - 1))

namespace mozilla::glean {

using Telemetry::EventID;


static inline Maybe<EventID> EventIdForMetric(uint32_t aId) {
  switch(aId) {
    case 38: { // browser.launched_to_handle.system_notification
      return Some(EventID::BrowserLaunched_to_handle_SystemNotification_Toast);
    }
    case 130: { // privacy.ui.fpp.click.checkbox
      return Some(EventID::PrivacyUiFpp_Click_Checkbox);
    }
    case 131: { // privacy.ui.fpp.click.menu
      return Some(EventID::PrivacyUiFpp_Click_Menu);
    }
    case 2590: { // mfcdm.eme_playback
      return Some(EventID::Mfcdm_EmePlayback_Gecko);
    }
    case 2591: { // mfcdm.error
      return Some(EventID::Mfcdm_Error_Gecko);
    }
    case 2870: { // cookie.banners.reload
      return Some(EventID::Cookie_banner_Reload_Browser);
    }
    case 3011: { // test_only.ipc.an_event
      return Some(EventID::TelemetryTest_MirrorWithExtra_Object1);
    }
    case 3016: { // test_only.ipc.no_extra_event
      return Some(EventID::TelemetryTest_NotExpiredOptout_Object1);
    }
    default: {
      if (MOZ_UNLIKELY(aId & (1 << DYNAMIC_METRIC_BIT))) {
        // Dynamic (runtime-registered) metric. Use its static (compiletime-
        // registered) metric's telemetry_mirror mapping.
        // ...if applicable.

        // Only JS can use dynamic (runtime-registered) metric ids.
        MOZ_ASSERT(NS_IsMainThread());

        auto metricName = JOG::GetMetricName(aId);
        // All of these should have names, but the storage only lasts until
        // XPCOMWillShutdown, so it might return `Nothing()`.
        if (metricName.isSome()) {
          auto maybeMetric = MetricByNameLookup(metricName.ref());
          if (maybeMetric.isSome()) {
            uint32_t staticId = GLEAN_METRIC_ID(maybeMetric.value());
            // Let's ensure we don't infinite loop, huh.
            MOZ_ASSERT(!(staticId & (1 << DYNAMIC_METRIC_BIT)));
            return EventIdForMetric(staticId);
          }
        }
      }
      return Nothing();
    }
  }
}

}  // namespace mozilla::glean

#undef GLEAN_METRIC_ID
#undef DYNAMIC_METRIC_BIT

#endif  // mozilla_glean_EventGifftMaps_h
