/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.descriptorparser.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.GeoipFile;
import org.torproject.descriptor.GeoipNamesFile;
import org.torproject.descriptor.impl.DescriptorReaderImpl;
import org.torproject.metrics.descriptorparser.utils.FormattingUtils;
import org.torproject.metrics.descriptorparser.utils.LookupResult;

public class LookupService {
    private static final Logger logger = LoggerFactory.getLogger(LookupService.class);
    private final File geoipDir;
    private GeoipFile geoip;
    private GeoipFile geoip6;
    private GeoipNamesFile countries;
    private GeoipNamesFile asns;
    private boolean hasAllFiles = false;
    private final Pattern ipv4Pattern = Pattern.compile("^[0-9.]{7,15}$");
    private int addressesLookedUp = 0;
    private int addressesResolved = 0;
    private int addressesCountryResolved = 0;
    private int addressesAsnResolved = 0;

    public LookupService(File geoipDir) {
        this.geoipDir = geoipDir;
        this.findRequiredCsvFiles();
    }

    private void findRequiredCsvFiles() {
        File geoip = new File(this.geoipDir, "geoip");
        for (Descriptor descriptor : new DescriptorReaderImpl().readDescriptors(geoip)) {
            if (!(descriptor instanceof GeoipFile)) continue;
            this.geoip = (GeoipFile)descriptor;
        }
        File geoip6 = new File(this.geoipDir, "geoip6");
        for (Descriptor descriptor : new DescriptorReaderImpl().readDescriptors(geoip6)) {
            if (!(descriptor instanceof GeoipFile)) continue;
            this.geoip6 = (GeoipFile)descriptor;
        }
        File file = new File(this.geoipDir, "countries.txt");
        for (Descriptor g : new DescriptorReaderImpl().readDescriptors(file)) {
            if (!(g instanceof GeoipNamesFile)) continue;
            this.countries = (GeoipNamesFile)g;
        }
        File file2 = new File(this.geoipDir, "asn.txt");
        for (Descriptor g : new DescriptorReaderImpl().readDescriptors(file2)) {
            if (!(g instanceof GeoipNamesFile)) continue;
            this.asns = (GeoipNamesFile)g;
        }
        this.hasAllFiles = null != this.geoip && null != this.geoip6 && null != this.countries && null != this.asns;
    }

    public SortedMap<String, LookupResult> lookup(SortedSet<String> addressStrings) {
        TreeMap<String, LookupResult> lookupResults = new TreeMap<String, LookupResult>();
        if (!this.hasAllFiles) {
            return lookupResults;
        }
        HashMap<String, String> addressCountries = new HashMap<String, String>();
        HashMap<String, String> addressAsn = new HashMap<String, String>();
        for (String addressString : addressStrings) {
            GeoipFile geoipFile = this.ipv4Pattern.matcher(addressString).matches() ? this.geoip : this.geoip6;
            try {
                String asn;
                Optional<GeoipFile.GeoipEntry> entry = geoipFile.getEntry(InetAddress.getByName(addressString));
                if (!entry.isPresent()) continue;
                String countryCode = entry.get().getCountryCode();
                if (null != countryCode) {
                    addressCountries.put(addressString, countryCode);
                }
                if (null == (asn = entry.get().getAutonomousSystemNumber())) continue;
                addressAsn.put(addressString, asn);
            }
            catch (UnknownHostException e) {
                logger.error("Tried to look up " + addressString + " which is not an IP address.");
            }
        }
        for (String addressString : addressStrings) {
            LookupResult lookupResult = new LookupResult();
            String countryCode = addressCountries.getOrDefault(addressString, null);
            String asn = addressAsn.getOrDefault(addressString, null);
            if (null == countryCode && null == asn) continue;
            if (null != countryCode) {
                lookupResult.setCountryCode(countryCode.toLowerCase());
                lookupResult.setCountryName((String)this.countries.get(countryCode.toUpperCase()));
            }
            if (null != asn) {
                lookupResult.setAsNumber("AS" + asn);
                lookupResult.setAsName((String)this.asns.get(asn));
            }
            lookupResults.put(addressString, lookupResult);
        }
        this.addressesLookedUp += addressStrings.size();
        this.addressesCountryResolved += addressCountries.size();
        this.addressesAsnResolved += addressAsn.size();
        this.addressesResolved += lookupResults.size();
        return lookupResults;
    }

    private BufferedReader createBufferedReaderFromUtf8File(File utf8File) throws FileNotFoundException {
        return this.createBufferedReaderFromFile(utf8File, StandardCharsets.UTF_8.newDecoder());
    }

    private BufferedReader createBufferedReaderFromFile(File file, CharsetDecoder dec) throws FileNotFoundException {
        dec.onMalformedInput(CodingErrorAction.REPORT);
        dec.onUnmappableCharacter(CodingErrorAction.REPORT);
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), dec));
    }

    public String getStatsString() {
        return String.format("    %s addresses looked up\n    %s addresses resolved (any)\n    %s addresses resolved (country)\n    %s addresses resolved (ASN)\n", FormattingUtils.formatDecimalNumber(this.addressesLookedUp), FormattingUtils.formatDecimalNumber(this.addressesResolved), FormattingUtils.formatDecimalNumber(this.addressesCountryResolved), FormattingUtils.formatDecimalNumber(this.addressesAsnResolved));
    }
}

